/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.teleportation;

import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.NewChunkTrackingGraph;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEServerPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEServerPlayerEntity;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.platform_specific.forge.networking.Dim_Confirm;
import qouteall.imm_ptl.core.platform_specific.forge.networking.IPMessage;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.teleportation.TeleportationUtil;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.dimension.DynamicDimensionsImpl;
import qouteall.q_misc_util.my_util.LimitedLogger;
import qouteall.q_misc_util.my_util.MyTaskList;
import qouteall.q_misc_util.my_util.WithDim;

public class ServerTeleportationManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private Set<Entity> teleportingEntities = new HashSet<Entity>();
    private WeakHashMap<Entity, Long> lastTeleportGameTime = new WeakHashMap();
    public boolean isFiringMyChangeDimensionEvent = false;
    public final WeakHashMap<ServerPlayer, WithDim<Vec3>> lastPosition = new WeakHashMap();
    private static final LimitedLogger limitedLogger = new LimitedLogger(20);

    public ServerTeleportationManager() {
        IPGlobal.postServerTickSignal.connectWithWeakRef(this, ServerTeleportationManager::tick);
        Portal.serverPortalTickSignal.connectWithWeakRef(this, (this_, portal) -> ServerTeleportationManager.getEntitiesToTeleport(portal).forEach(entity -> this_.startTeleportingRegularEntity((Portal)portal, (Entity)entity)));
        DynamicDimensionsImpl.beforeRemovingDimensionSignal.connect(this::evacuatePlayersFromDimension);
    }

    private void tick() {
        this.teleportingEntities.clear();
        long tickTimeNow = McHelper.getServerGameTime();
        if (tickTimeNow % 30L == 7L) {
            for (ServerPlayer player : McHelper.getRawPlayerList()) {
                this.updateForPlayer(tickTimeNow, player);
            }
        }
        this.manageGlobalPortalTeleportation();
    }

    public static boolean shouldEntityTeleport(Portal portal, Entity entity) {
        if (entity.m_9236_() != portal.m_9236_()) {
            return false;
        }
        if (!portal.canTeleportEntity(entity)) {
            return false;
        }
        Vec3 lastEyePos = entity.m_20299_(0.0f);
        Vec3 nextEyePos = entity.m_20299_(1.0f);
        if (entity instanceof Projectile) {
            nextEyePos = nextEyePos.m_82549_(McHelper.getWorldVelocity(entity));
        }
        boolean movedThroughPortal = portal.isMovedThroughPortal(lastEyePos, nextEyePos);
        return movedThroughPortal;
    }

    public void startTeleportingRegularEntity(Portal portal, Entity entity) {
        if (entity instanceof ServerPlayer) {
            return;
        }
        if (entity instanceof Portal) {
            return;
        }
        if (entity.m_20202_() != null || this.doesEntityClusterContainPlayer(entity)) {
            return;
        }
        if (entity.m_213877_()) {
            return;
        }
        if (!entity.m_6072_()) {
            return;
        }
        if (this.isJustTeleported(entity, 1L)) {
            return;
        }
        if (entity.f_19854_ == 0.0 && entity.f_19855_ == 0.0 && entity.f_19856_ == 0.0) {
            LOGGER.warn("Trying to teleport a fresh new entity {}", (Object)entity);
            return;
        }
        double motion = McHelper.lastTickPosOf(entity).m_82557_(entity.m_20182_());
        if (motion > 20.0) {
            return;
        }
        IPGlobal.serverTaskList.addTask(() -> {
            try {
                this.teleportRegularEntity(entity, portal);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return true;
        });
    }

    private static Stream<Entity> getEntitiesToTeleport(Portal portal) {
        return portal.m_9236_().m_6443_(Entity.class, portal.m_20191_().m_82400_(2.0), e -> true).stream().filter(e -> !(e instanceof Portal)).filter(entity -> ServerTeleportationManager.shouldEntityTeleport(portal, entity));
    }

    public void onPlayerTeleportedInClient(ServerPlayer player, ResourceKey<Level> dimensionBefore, Vec3 oldEyePos, UUID portalId) {
        if (player.m_146911_() != null) {
            Helper.err("Trying to teleport a removed player " + String.valueOf(player));
            return;
        }
        Portal portal = this.findPortal(dimensionBefore, portalId);
        this.lastTeleportGameTime.put((Entity)player, McHelper.getServerGameTime());
        Vec3 oldFeetPos = oldEyePos.m_82546_(McHelper.getEyeOffset((Entity)player));
        if (this.canPlayerTeleport(player, dimensionBefore, oldFeetPos, portal)) {
            if (this.isTeleporting((Entity)player)) {
                Helper.log(player.toString() + "is teleporting frequently");
            }
            ServerTeleportationManager.notifyChasersForPlayer(player, portal);
            ResourceKey<Level> dimensionTo = portal.dimensionTo;
            Vec3 newEyePos = portal.transformPoint(oldEyePos);
            this.recordLastPosition(player, dimensionBefore, oldFeetPos);
            this.teleportPlayer(player, dimensionTo, newEyePos);
            portal.onEntityTeleportedOnServer((Entity)player);
            PehkuiInterface.invoker.onServerEntityTeleported((Entity)player, portal);
            if (portal.getTeleportChangesGravity()) {
                Direction oldGravityDir = GravityChangerInterface.invoker.getGravityDirection((Entity)player);
                GravityChangerInterface.invoker.setBaseGravityDirectionServer((Entity)player, portal.getTransformedGravityDirection(oldGravityDir));
            }
        } else {
            Helper.err(String.format("Player cannot teleport through portal %s %s %s %s", player.m_7755_().m_214077_(), player.m_9236_().m_46472_(), player.m_20182_(), portal));
            ServerTeleportationManager.teleportEntityGeneral((Entity)player, player.m_20182_(), (ServerLevel)player.m_9236_());
            PehkuiInterface.invoker.setBaseScale((Entity)player, PehkuiInterface.invoker.getBaseScale((Entity)player));
            GravityChangerInterface.invoker.setBaseGravityDirectionServer((Entity)player, GravityChangerInterface.invoker.getGravityDirection((Entity)player));
        }
    }

    private Portal findPortal(ResourceKey<Level> dimensionBefore, UUID portalId) {
        ServerLevel originalWorld = MiscHelper.getServer().m_129880_(dimensionBefore);
        Entity portalEntity = originalWorld.m_8791_(portalId);
        if (portalEntity == null) {
            portalEntity = GlobalPortalStorage.get((ServerLevel)originalWorld).data.stream().filter(p -> p.m_20148_().equals(portalId)).findFirst().orElse(null);
        }
        if (portalEntity == null) {
            return null;
        }
        if (portalEntity instanceof Portal) {
            return (Portal)portalEntity;
        }
        return null;
    }

    public void recordLastPosition(ServerPlayer player, ResourceKey<Level> dim, Vec3 pos) {
        this.lastPosition.put(player, new WithDim<Vec3>(dim, pos));
    }

    private boolean canPlayerTeleport(ServerPlayer player, ResourceKey<Level> dimensionBefore, Vec3 posBefore, Entity portalEntity) {
        if (player.m_20202_() != null) {
            return true;
        }
        if (!(portalEntity instanceof Portal)) {
            return false;
        }
        Portal portal = (Portal)portalEntity;
        return portal.canTeleportEntity((Entity)player) && player.m_9236_().m_46472_() == dimensionBefore && player.m_20182_().m_82557_(posBefore) < 256.0 && portal.getDistanceToPlane(posBefore) < 20.0;
    }

    public static boolean canPlayerReachPos(ServerPlayer player, ResourceKey<Level> dimension, Vec3 pos) {
        Vec3 playerPos = player.m_20182_();
        if (player.m_9236_().m_46472_() == dimension && playerPos.m_82557_(pos) < 256.0) {
            return true;
        }
        return IPMcHelper.getNearbyPortals((Entity)player, 20.0).filter(portal -> portal.dimensionTo == dimension).filter(portal -> portal.canTeleportEntity((Entity)player)).map(portal -> portal.transformPoint(playerPos)).anyMatch(mappedPos -> mappedPos.m_82557_(pos) < 256.0);
    }

    public static boolean canPlayerReachBlockEntity(ServerPlayer player, BlockEntity blockEntity) {
        return ServerTeleportationManager.canPlayerReachPos(player, (ResourceKey<Level>)blockEntity.m_58904_().m_46472_(), Vec3.m_82512_((Vec3i)blockEntity.m_58899_()));
    }

    public void teleportPlayer(ServerPlayer player, ResourceKey<Level> dimensionTo, Vec3 newEyePos) {
        MiscHelper.getServer().m_129905_().m_6180_("portal_teleport");
        ServerLevel fromWorld = (ServerLevel)player.m_9236_();
        ServerLevel toWorld = MiscHelper.getServer().m_129880_(dimensionTo);
        if (player.m_9236_().m_46472_() == dimensionTo) {
            McHelper.setEyePos((Entity)player, newEyePos, newEyePos);
            McHelper.updateBoundingBox((Entity)player);
        } else {
            this.changePlayerDimension(player, fromWorld, toWorld, newEyePos);
            ((IEServerPlayNetworkHandler)player.f_8906_).cancelTeleportRequest();
        }
        McHelper.adjustVehicle((Entity)player);
        player.f_8906_.m_9953_();
        MiscHelper.getServer().m_129905_().m_7238_();
    }

    public void forceTeleportPlayer(ServerPlayer player, ResourceKey<Level> dimensionTo, Vec3 newPos) {
        ServerLevel fromWorld = (ServerLevel)player.m_9236_();
        ServerLevel toWorld = MiscHelper.getServer().m_129880_(dimensionTo);
        if (player.m_9236_().m_46472_() == dimensionTo) {
            player.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        } else {
            this.changePlayerDimension(player, fromWorld, toWorld, newPos.m_82549_(McHelper.getEyeOffset((Entity)player)));
            ServerTeleportationManager.sendPositionConfirmMessage(player);
        }
        player.f_8906_.m_9774_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, player.m_146908_(), player.m_146909_());
        player.f_8906_.m_9953_();
        ((IEServerPlayNetworkHandler)player.f_8906_).cancelTeleportRequest();
        NewChunkTrackingGraph.updateForPlayer(player);
    }

    private void changePlayerDimension(ServerPlayer player, ServerLevel fromWorld, ServerLevel toWorld, Vec3 newEyePos) {
        this.teleportingEntities.add((Entity)player);
        Entity vehicle = player.m_20202_();
        if (vehicle != null) {
            ((IEServerPlayerEntity)player).stopRidingWithoutTeleportRequest();
        }
        Vec3 oldPos = player.m_20182_();
        fromWorld.m_143261_(player, Entity.RemovalReason.CHANGED_DIMENSION);
        ((IEEntity)player).ip_unsetRemoved();
        McHelper.setEyePos((Entity)player, newEyePos, newEyePos);
        McHelper.updateBoundingBox((Entity)player);
        player.m_284127_(toWorld);
        player.reviveCaps();
        toWorld.m_8817_(player);
        if (vehicle != null) {
            Vec3 offset = McHelper.getVehicleOffsetFromPassenger(vehicle, (Entity)player);
            Vec3 vehiclePos = player.m_20182_().m_82549_(offset);
            vehicle = this.teleportVehicleAcrossDimensions(vehicle, (ResourceKey<Level>)toWorld.m_46472_(), vehiclePos.m_82549_(McHelper.getEyeOffset(vehicle)));
            McHelper.setPosAndLastTickPos(vehicle, player.m_20182_().m_82549_(offset), McHelper.lastTickPosOf((Entity)player).m_82549_(offset));
            ((IEServerPlayerEntity)player).startRidingWithoutTeleportRequest(vehicle);
            McHelper.adjustVehicle((Entity)player);
        }
        Helper.dbg(String.format("%s :: (%s %s %s %s)->(%s %s %s %s)", player.m_7755_().m_214077_(), fromWorld.m_46472_().m_135782_(), oldPos.m_7096_(), oldPos.m_7098_(), oldPos.m_7094_(), toWorld.m_46472_().m_135782_(), (int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_()));
        O_O.onPlayerTravelOnServer(player, (ResourceKey<Level>)fromWorld.m_46472_(), (ResourceKey<Level>)toWorld.m_46472_());
        ((IEServerPlayerEntity)player).portal_worldChanged(fromWorld, oldPos);
        Helper.dbg("Forge Event PlayerEvent.PlayerChangedDimensionEvent fired");
        ForgeEventFactory.firePlayerChangedDimensionEvent((Player)player, (ResourceKey)fromWorld.m_46472_(), (ResourceKey)toWorld.m_46472_());
    }

    public static void sendPositionConfirmMessage(ServerPlayer player) {
        IPMessage.sendToPlayer(new Dim_Confirm((ResourceKey<Level>)player.m_9236_().m_46472_(), player.m_20182_()), player);
    }

    private void manageGlobalPortalTeleportation() {
        for (ServerLevel world : MiscHelper.getServer().m_129785_()) {
            for (Entity entity : world.m_8583_()) {
                Portal collidingPortal;
                if (entity instanceof ServerPlayer || (collidingPortal = ((IEEntity)entity).ip_getCollidingPortal()) == null || !collidingPortal.getIsGlobal() || !ServerTeleportationManager.shouldEntityTeleport(collidingPortal, entity)) continue;
                this.startTeleportingRegularEntity(collidingPortal, entity);
            }
        }
    }

    private void updateForPlayer(long tickTimeNow, ServerPlayer player) {
        if (player.f_8944_ || player.m_8958_()) {
            this.lastTeleportGameTime.put((Entity)player, tickTimeNow);
            return;
        }
        Long lastTeleportGameTime = this.lastTeleportGameTime.getOrDefault(player, 0L);
        if (tickTimeNow - lastTeleportGameTime > 60L) {
            ServerTeleportationManager.sendPositionConfirmMessage(player);
            player.m_8959_();
        } else {
            ((IEServerPlayNetworkHandler)player.f_8906_).cancelTeleportRequest();
        }
    }

    public boolean isTeleporting(Entity entity) {
        return this.teleportingEntities.contains(entity);
    }

    private void teleportRegularEntity(Entity entity, Portal portal) {
        Long lastTeleportGameTime;
        Validate.isTrue((!(entity instanceof ServerPlayer) ? 1 : 0) != 0);
        if (entity.m_146911_() != null) {
            Helper.err(String.format("Trying to teleport an entity that is already removed %s %s", entity, portal));
            return;
        }
        if (entity.m_9236_() != portal.m_9236_()) {
            Helper.err(String.format("Cannot teleport %s from %s through %s", entity, entity.m_9236_().m_46472_(), portal));
            return;
        }
        if (portal.getDistanceToNearestPointInPortal(entity.m_146892_()) > 5.0) {
            Helper.err("Entity is too far to teleport " + String.valueOf(entity) + String.valueOf(portal));
            return;
        }
        long currGameTime = McHelper.getServerGameTime();
        if (currGameTime - (lastTeleportGameTime = this.lastTeleportGameTime.getOrDefault(entity, 0L)) <= 0L) {
            return;
        }
        this.lastTeleportGameTime.put(entity, currGameTime);
        if (entity.m_20159_() || this.doesEntityClusterContainPlayer(entity)) {
            return;
        }
        Vec3 velocity = entity.m_20184_();
        List passengerList = entity.m_20197_();
        Vec3 newEyePos = ServerTeleportationManager.getRegularEntityTeleportedEyePos(entity, portal);
        TeleportationUtil.transformEntityVelocity(portal, entity, TeleportationUtil.PortalPointVelocity.zero);
        if (portal.dimensionTo != entity.m_9236_().m_46472_()) {
            Entity newEntity = entity = this.changeEntityDimension(entity, portal.dimensionTo, newEyePos, true);
            passengerList.stream().map(e -> this.changeEntityDimension((Entity)e, portal.dimensionTo, newEyePos, true)).collect(Collectors.toList()).forEach(e -> e.m_7998_(newEntity, true));
        }
        McHelper.setEyePos(entity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(entity);
        McHelper.sendToTrackers(entity, McRemoteProcedureCall.createPacketToSendToClient("qouteall.imm_ptl.core.teleportation.ClientTeleportationManager.RemoteCallables.updateEntityPos", entity.m_9236_().m_46472_(), entity.m_19879_(), entity.m_20182_()));
        portal.onEntityTeleportedOnServer(entity);
        PehkuiInterface.invoker.onServerEntityTeleported(entity, portal);
        this.lastTeleportGameTime.put(entity, currGameTime);
    }

    private static Vec3 getRegularEntityTeleportedEyePos(Entity entity, Portal portal) {
        Vec3 eyePosLastTick;
        Vec3 deltaMovement;
        Vec3 deltaMovementDirection;
        Vec3 eyePosThisTick = McHelper.getEyePos(entity);
        Vec3 collidingPoint = portal.rayTrace(eyePosThisTick.m_82546_((deltaMovementDirection = (deltaMovement = eyePosThisTick.m_82546_(eyePosLastTick = McHelper.getLastTickEyePos(entity))).m_82541_()).m_82490_(5.0)), eyePosThisTick.m_82549_(deltaMovementDirection));
        if (collidingPoint == null) {
            collidingPoint = portal.getPointProjectedToPlane(eyePosThisTick);
        }
        Vec3 result = portal.transformPoint(collidingPoint).m_82549_(portal.getContentDirection().m_82490_(0.05));
        return result;
    }

    public Entity changeEntityDimension(Entity entity, ResourceKey<Level> toDimension, Vec3 newEyePos, boolean recreateEntity) {
        if (entity.m_146911_() != null) {
            Helper.err("Trying to teleport a removed entity " + String.valueOf(entity));
            new Throwable().printStackTrace();
            return entity;
        }
        ServerLevel fromWorld = (ServerLevel)entity.m_9236_();
        ServerLevel toWorld = MiscHelper.getServer().m_129880_(toDimension);
        entity.m_19877_();
        if (recreateEntity) {
            Entity oldEntity = entity;
            Entity newEntity = entity.m_6095_().m_20615_((Level)toWorld);
            if (newEntity == null) {
                return oldEntity;
            }
            newEntity.m_20361_(oldEntity);
            newEntity.m_20234_(oldEntity.m_19879_());
            McHelper.setEyePos(newEntity, newEyePos, newEyePos);
            McHelper.updateBoundingBox(newEntity);
            newEntity.m_5616_(oldEntity.m_6080_());
            oldEntity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
            ((IEEntity)oldEntity).ip_unsetRemoved();
            toWorld.m_143334_(newEntity);
            return newEntity;
        }
        entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        ((IEEntity)entity).ip_unsetRemoved();
        McHelper.setEyePos(entity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(entity);
        ((IEEntity)entity).ip_setWorld((Level)toWorld);
        toWorld.m_143334_(entity);
        Validate.isTrue((!entity.m_213877_() ? 1 : 0) != 0);
        return entity;
    }

    public Entity teleportVehicleAcrossDimensions(Entity entity, ResourceKey<Level> toDimension, Vec3 newEyePos) {
        this.teleportingEntities.add(entity);
        ServerLevel fromWorld = (ServerLevel)entity.m_9236_();
        ServerLevel toWorld = MiscHelper.getServer().m_129880_(toDimension);
        Entity oldEntity = entity;
        Entity newEntity = entity.m_6095_().m_20615_((Level)toWorld);
        Validate.isTrue((newEntity != null ? 1 : 0) != 0);
        newEntity.m_20361_(oldEntity);
        newEntity.m_20234_(oldEntity.m_19879_());
        McHelper.setEyePos(newEntity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(newEntity);
        newEntity.m_5616_(oldEntity.m_6080_());
        oldEntity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        ((IEEntity)oldEntity).ip_unsetRemoved();
        toWorld.m_143334_(newEntity);
        return newEntity;
    }

    private boolean doesEntityClusterContainPlayer(Entity entity) {
        if (entity instanceof Player) {
            return true;
        }
        List passengerList = entity.m_20197_();
        if (passengerList.isEmpty()) {
            return false;
        }
        return passengerList.stream().anyMatch(this::doesEntityClusterContainPlayer);
    }

    public boolean isJustTeleported(Entity entity, long valveTickTime) {
        Long lastTeleportGameTime;
        long currGameTime = McHelper.getServerGameTime();
        return currGameTime - (lastTeleportGameTime = this.lastTeleportGameTime.getOrDefault(entity, -100000L)) < valveTickTime;
    }

    @Deprecated
    public void acceptDubiousMovePacket(ServerPlayer player, ServerboundMovePlayerPacket packet, ResourceKey<Level> dimension) {
        double z;
        double y;
        if (player.m_9236_().m_46472_() == dimension) {
            return;
        }
        if (player.m_146911_() != null) {
            return;
        }
        double x = packet.m_134129_(player.m_20185_());
        Vec3 newPos = new Vec3(x, y = packet.m_134140_(player.m_20186_()), z = packet.m_134146_(player.m_20189_()));
        if (ServerTeleportationManager.canPlayerReachPos(player, dimension, newPos)) {
            this.forceTeleportPlayer(player, dimension, newPos);
            limitedLogger.lInfo(LOGGER, "accepted dubious move packet {} {} {} {} {} {} {}", player.m_9236_().m_46472_().m_135782_(), x, y, z, player.m_20185_(), player.m_20186_(), player.m_20189_());
        } else {
            limitedLogger.lInfo(LOGGER, "ignored dubious move packet {} {} {} {} {} {} {}", player.m_9236_().m_46472_().m_135782_(), x, y, z, player.m_20185_(), player.m_20186_(), player.m_20189_());
        }
    }

    public static void teleportEntityGeneral(Entity entity, Vec3 targetPos, ServerLevel targetWorld) {
        if (entity instanceof ServerPlayer) {
            IPGlobal.serverTeleportationManager.forceTeleportPlayer((ServerPlayer)entity, (ResourceKey<Level>)targetWorld.m_46472_(), targetPos);
        } else {
            ServerTeleportationManager.teleportRegularEntityTo(entity, (ResourceKey<Level>)targetWorld.m_46472_(), targetPos);
        }
    }

    public static <E extends Entity> E teleportRegularEntityTo(E entity, ResourceKey<Level> targetDim, Vec3 targetPos) {
        if (entity.m_9236_().m_46472_() == targetDim) {
            entity.m_7678_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, entity.m_146908_(), entity.m_146909_());
            entity.m_5616_(entity.m_146908_());
            return entity;
        }
        return (E)IPGlobal.serverTeleportationManager.changeEntityDimension(entity, targetDim, targetPos.m_82549_(McHelper.getEyeOffset(entity)), true);
    }

    private static void notifyChasersForPlayer(ServerPlayer player, Portal portal) {
        List<Mob> chasers = McHelper.findEntitiesRough(Mob.class, player.m_9236_(), player.m_20182_(), 1, e -> e.m_5448_() == player);
        for (Mob chaser : chasers) {
            chaser.m_6710_(null);
            ServerTeleportationManager.notifyChaser(player, portal, chaser);
        }
    }

    private static void notifyChaser(ServerPlayer player, Portal portal, Mob chaser) {
        Vec3 targetPos = player.m_20182_().m_82549_(portal.getNormal().m_82490_(-0.1));
        UUID chaserId = chaser.m_20148_();
        ServerLevel destWorld = (ServerLevel)portal.getDestinationWorld();
        IPGlobal.serverTaskList.addTask(MyTaskList.withRetryNumberLimit(140, () -> {
            if (chaser.m_213877_()) {
                Entity newChaser = destWorld.m_8791_(chaserId);
                if (newChaser instanceof Mob) {
                    ((Mob)newChaser).m_6710_((LivingEntity)player);
                    return true;
                }
                return false;
            }
            if (chaser.m_20182_().m_82554_(targetPos) < 2.0) {
                chaser.m_21566_().m_6849_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 1.0);
            } else {
                @Nullable Path path = chaser.m_21573_().m_7864_(BlockPos.m_274446_((Position)targetPos), 0);
                chaser.m_21573_().m_26536_(path, 1.0);
            }
            return false;
        }, () -> {}));
    }

    private void evacuatePlayersFromDimension(ResourceKey<Level> dim) {
        PlayerList playerList = MiscHelper.getServer().m_6846_();
        for (ServerPlayer player : playerList.m_11314_()) {
            if (player.m_9236_().m_46472_() != dim) continue;
            ServerLevel overWorld = McHelper.getOverWorldOnServer();
            BlockPos spawnPos = overWorld.m_220360_();
            this.forceTeleportPlayer(player, (ResourceKey<Level>)Level.f_46428_, Vec3.m_82512_((Vec3i)spawnPos));
            player.m_213846_((Component)Component.m_237113_((String)"Teleported to spawn pos because dimension %s had been removed".formatted(dim.m_135782_())));
        }
    }
}

